#version 430



vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec4 rotateYZ(vec4 p, float a) {
  vec4 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}

layout(triangles) in;
layout(triangle_strip, max_vertices = 3) out;
//layout(line_strip, max_vertices = 15) out;

in vec3 normal[3];
in vec2 uv[3];
in vec3 tangent[3];
in vec4 origPos[3];
in vec3 instPos[3];

in vec3 instVel[3];
in float instAge[3];
in float instRec[3];

out vec4 posG;
out vec4 posW;
out vec4 posInst;
out float ageG;


uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 modelMatrix;
uniform mat4 viewMatrix;

uniform float g_time;

uniform float windowWidth;
uniform float windowHeight;

uniform float furLength = 1.0;

// uniform float makkara;

layout(binding=0) uniform sampler2D texColor;
layout(binding=1) uniform sampler2D texDepthNorm;
layout(binding=2) uniform sampler2D texEnv;
layout(binding=3) uniform sampler2D texPrevFrame;
layout(binding=4) uniform sampler2D texDepth;

uniform float zNear = 0.1;
uniform float zFar = 1000.0;
// convert from 0.0 to 1.0 depth sample ds to linear depth
float linearDepth(float ds) {
    ds = 2.0*ds-1.0;
    float zLinear = 2.0*zNear*zFar/(zFar+zNear-ds*(zFar-zNear));
    return zLinear;
}

float atanSafe(float y, float x) {
 float ret=0.0;
        if (x!=0.0) {
                if (x>0.0) {
                        ret=atan(y/x);
                } else	{
                        ret=atan(y/x)+3.141592;
                }
        } else {
                if (y>=0.0) {
                        ret=0.5*3.141592;
                } else {
                        ret=-0.5*3.141592;
                }
        }
 return ret;
}

void main(void) {

        vec3 controlBase = vec3(0.0);

        float times = g_time*0.1;
       vec3 faceNormal = vec3(0.0);
        vec4 facePos = vec4(0.0);

        float rotAngle = atanSafe(instVel[0].y,instVel[0].x)+0.50*3.141592;

        mat4 mvp = projectionMatrix * modelViewMatrix;


        for (int i = 0; i < gl_in.length(); ++i) {
                gl_Position = gl_in[i].gl_Position; // -vec4(1.5, 0.0, 0.0, 0.0);
                posW = gl_Position;
                posInst = viewMatrix*vec4(instPos[i]*0.50, 1.0); // + modelMatrix*vec4(instPos[i], 1.0);
                gl_Position = modelViewMatrix*gl_Position + 1.0*viewMatrix*vec4(instPos[i], 1.0);
                gl_Position = projectionMatrix*gl_Position;
                posG = gl_Position;
                ageG = instAge[0];
                EmitVertex();
        }
        facePos /= 3.0;
        EndPrimitive();
}
